<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-09-24 12:56
 */
interface OfferproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Offerproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param offerproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Offerproduct offerproduct
 	 */
	public function insert($offerproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Offerproduct offerproduct
 	 */
	public function update($offerproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByProductid($value);

	public function queryByQuantity($value);

	public function queryByStorequant($value);

	public function queryByAvailablequant($value);

	public function queryByMiunquant($value);

	public function queryByPrice($value);

	public function queryByTotal($value);


	public function deleteByClientid($value);

	public function deleteByProductid($value);

	public function deleteByQuantity($value);

	public function deleteByStorequant($value);

	public function deleteByAvailablequant($value);

	public function deleteByMiunquant($value);

	public function deleteByPrice($value);

	public function deleteByTotal($value);


}
?>